*
* TDBS User List Utility
* Revision 1.00
* Written by Alan D. Bryant
* for eSoft, Inc.
*
****************************************************************************
* This program source is included with your TDBS to illustrate techniques. *
* You may use any or all of the source or techniques illustrated in this   *
* program in any fashion you wish.  There are no fees or restrictions      *
* imposed on the use of this code by eSoft, Inc.                           *
****************************************************************************
*
* PURPOSE:  This program opens the USERLOG.BBS file in read-only mode, and
* lists all users by name and location.  A /NL switch on the Opt Data line
* of the calling menu entry will suppress the callers' location display.
*
* CONCEPTS ILLUSTRATED:  The program illustrates the use of Opt Data command
* line parsing, as well as the low-level file I/O system.
*
* FLOW:  The USERLOG.BBS file is opened, and read in 4096 byte blocks.
* Each 512 byte userlog record is handled individually.  These operations
* occur in a loop until the end of file is reached.
*
* POSSIBLE ENHANCEMENTS:  The output could be formatted in a more
* cosmetically pleasing manner.  Other userlog data, such as date and time
* of last call could also be displayed since the userlog record is
* present and active.  (Refer to Chapter 13 of the TBBS manual for the
* format of the USERLOG.BBS file and the byte offsets of the information
* therein.)
*




*
* setup a routine to trap user keypresses during display
*
on key do checkkey

*
* open userlog file in read-only binary mode
*
fopen handle "userlog.bbs" 0 4096
if handle = -1
    ? "USEARCH: Error on opening USERLOG.BBS"
    ? "USEARCH: Error was: "+message(ferror(handle))
    wait
    quit
endif


*
* show banner
*
? "List of all users on system:"
? ""


*
* analyize Opt Data and see if there's a /NL in it.
*
offset = at("/NL", upper(optdata()))
if offset # 0
    location = .F.
else
    location = .T.
endif

*
* establish a user counter for emulation of "more" setting
*
counter = 3

*
* set up a loop to look at each userlog record
*
do while .t.

    *
    * read a record
    *
    fbread handle bytes handle 0 4096

    *
    * if 0 bytes were read, then we're at EOF or there was an error
    * so exit the loop
    *
    if bytes = 0
        exit
    endif

    *
    * setup a loop to process 512 bytes at a time
    *
    pass = 1

    do while .t.
        *
        * extract out the name of the user
        *
        readout = fbextract(handle, (pass * 512) - 512 + 1, 50)
        offset = at(chr(0), readout)
        user = substr(readout, 1, offset - 1)

        *
        * extract out the location
        *
        locoffset = at(chr(0), substr(readout, offset + 1))
        location = substr(readout, offset + 1, locoffset)

        *
        * check if the user is invisible or not; if not, disply
        * user's name and location; if counter is 1, then display
        * on same line
        *
        mask = ulpeek(238, 5)
        if counter = 1
            if substr(mask, 8, 1) = "."
                ?? user + ", " + location
            else
                ?? user
            endif
        else
            if substr(mask, 8, 1) = "."
                ? user + ", " + location
            else
                ? user
            endif
        endif

        *
        * increment and check counter; emulate a "more"
        *
        counter = counter + 1
        if counter = umore()
            ? "-More-"
            key = inkey(60)
            if upper(chr(key)) = "S"
                quit
            endif
            ?? chr(8)+chr(8)+chr(8)+chr(8)+chr(8)+chr(8)
            counter = 1
        endif

        *
        * increment the pass counter
        * if we've used up all the bytes we read, then go back and read
        * more of them
        *
        pass = pass + 1
        if pass = (bytes / 512) + 1
            exit
        endif
    enddo

enddo
? ""
wait
quit



*
* procedure to check user keypresses during display
*
procedure checkkey

*
* get the key out of the input buffer
*
press = inkey(0)

*
* if the key is a "P" then pause (up to 255 seconds)
*
if upper(chr(press)) = "P"
    dummy = inkey(255)
endif

*
* if the key is an "S" then stop immediately
*
if upper(chr(press)) = "S"
    quit
endif

return
